package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.biz.RequestAdminLocationDocument;
import gov.va.vinci.dart.db.RequestAdminLocationDocumentDAO;

public class RequestAdminLocationDocumentDAOMock implements RequestAdminLocationDocumentDAO {

	private static HashMap<Integer,RequestAdminLocationDocument> IDHash = new HashMap<Integer,RequestAdminLocationDocument>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(RequestAdminLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
	
		initializeDocHash();
		
		if (document.getId() == 0) {
			document.setId(idCounter++);
		}
		
		IDHash.put(document.getId(), document);
	}

	@Override
	public void delete(RequestAdminLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		initializeDocHash();

		IDHash.remove(document.getId());
	}

	@Override
	public List<RequestAdminLocationDocument> listByRequestId(int requestId) {

		List<RequestAdminLocationDocument> result = new ArrayList<RequestAdminLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestAdminLocationDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId) {
				result.add(rald);
			}
		}

		return result;	
	}

	public List<RequestAdminLocationDocument> listByDocumentId(int documentId) {

		List<RequestAdminLocationDocument> result = new ArrayList<RequestAdminLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestAdminLocationDocument rald = IDHash.get(id);
			if (rald.getDocumentId() == documentId) {
				result.add(rald);
			}
		}

		return result;	
	}

	@Override
	public List<RequestAdminLocationDocument> listByRequestIdAndGroupId(
			int requestId, int groupId) {

		List<RequestAdminLocationDocument> result = new ArrayList<RequestAdminLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestAdminLocationDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId
					&& rald.getGroupId() == groupId) {
				result.add(rald);
			}
		}

		return result;	
	}

	private void initializeDocHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

}
